/************************************************************************************************
*   深圳市摩西尔电子有限公司 @版本所有@
*
*   此文件用于测试 大屏连接 页功能
*
* 修改:
*   1. 类型 : 创建
*      作者 : 陈小荟
*      时间 : 2021.05.12
*      内容 : 所有代码
************************************************************************************************/
/* global tc_tool_window_load_complete */
/* global tc_tool_dialog_define_cancel */
/* global tc_tool_get_iframe_pop_layer */
/* global tc_tool_get_main_htmliframe */
/* global tc_tool_get_iframe_window */
/* global get_webui_main_document */
/* global tc_tool_judge_jump_page */
/* global get_webui_pop_leyer */
/* global tc_tool_jump_page */
/* global $ */

/* exported tc_module_operate_add_and_delect */
/* exported tc_module_operate_add_screen */
/* exported tc_module_operate_info_disp */
/* exported tc_module_operate_transform */
/* exported tc_box_send_and_load_offset */
/* exported tc_module_operate_position */
/* exported tc_module_operate_compose */
/* exported tc_module_operate_replace */
/* exported tc_module_operate_select */
/* exported tc_module_operate_lock */
/* exported tc_module_operate_size */
/* exported tc_box_send_and_load */
/* exported tc_box_save_file */


/**
 * 回撤重做 测试
 *
 * 移动 move
 * 连线 connect
 * 添加、替换、删除 curd (tc_module_operate_add_and_delect)
 * 变换 transform (tc_module_operate_transform)
 * 锁定 lock (tc_module_operate_lock)
 * 组合 merge (tc_module_operate_compose)
 * 切换简易模式 mode
 */


// 指获取指定元素失败
var str_screen_error = "获取失败";
// 指测试前步骤失败
var str_screen_operate_error = "操作失败";
// 需要延迟时间
var ui_screen_delay = 1000;
var str_screen_url = "./pages/box_design/height_lever_layout.html?enter=add_screen";
var str_screen_url_param = "&is_save=";

function tc_box_send_and_load(callback) {
    tc_box_send("MC_LANG_BOX_CONFIGURATION_SEND_LOAD",callback);
    return;
}

function tc_box_send_and_load_offset(callback) {
    tc_box_send("MC_LANG_BOX_SEND_LOAD_OFFSET",callback);
    return;
}

function tc_box_save_file(callback) {
    tc_box_send("MC_LANG_BTN_SCREEN_SAVE_TO_FILE",callback);
    return;
}

function tc_module_operate_add_and_delect(callback) {
    tc_tool_judge_jump_page(str_screen_url,str_screen_url_param,add_and_delect);
    function add_and_delect() {
        tool_screen_add_box(callback,function () {
            var iframe_document = get_webui_main_document();
            var ui_module_cnt = 0;
            var str_redo_undo = "";

            iframe_document.onkeydown({keyCode: 67,ctrlKey: true});
            iframe_document.onkeydown({keyCode: 86,ctrlKey: true});
            setTimeout(function () {
                iframe_document.onkeydown({keyCode: 46});
                // redo undo
                ui_module_cnt = iframe_document.getElementsByClassName("mc_mod").length;
                tool_screen_redo_undo(iframe_document,true).then(()=>{
                    if (++ui_module_cnt === iframe_document.getElementsByClassName("mc_mod").length) {
                        str_redo_undo += "curd 回撤成功,";
                    } else {
                        str_redo_undo += "curd 回撤失败,";
                    }
                    return tool_screen_redo_undo(iframe_document,false);
                }).then(()=>{
                    if (ui_module_cnt - 1 === iframe_document.getElementsByClassName("mc_mod").length) {
                        str_redo_undo += "curd 重做成功";
                    } else {
                        str_redo_undo += "curd 重做失败";
                    }
                    callback(1,"添加、复制粘贴、删除成功；" + str_redo_undo);
                });
                return;
            },ui_screen_delay);
            return;
        },true);
        return;
    }
    return;
}

/*
 * 信息显示切换
 * 1. 存在至少两张卡
 * 2. 全选
 * 3. 连线
 * 4. 信息显示切换
 */
function tc_module_operate_info_disp(callback) {
    tc_tool_judge_jump_page(str_screen_url,str_screen_url_param,info_disp);
    function info_disp() {
        var iframe_document = get_webui_main_document();
        var obj_param = tool_screen_judge_is_create(iframe_document,2);

        // 1.
        tool_screen_add_box(callback,function () {
            // 2.
            iframe_document.onkeydown({keyCode: 65,ctrlKey: true});
            // 3.
            tool_screen_connect_line(tc_tool_get_iframe_window(),iframe_document,callback,function () {
                // 4.
                iframe_document.querySelector("div[lang_id='MC_LANG_INFO_DISP']").click();
                setTimeout(function () {
                    var obj_pop_layer = tc_tool_get_iframe_pop_layer(iframe_document);

                    if (!obj_pop_layer) {
                        callback(0,str_screen_error);
                        return;
                    }
                    tc_tool_window_load_complete(obj_pop_layer,function () {
                        var obj_checkbox_list = obj_pop_layer.getElementsByClassName("mc_checkbox_box");

                        for (var index = 0; index < obj_checkbox_list.length; index++) {
                            obj_checkbox_list[index].click();
                        }
                        obj_pop_layer.querySelector("div[lang_id='MC_LANG_BTN_APPLY']").click();
                        tc_tool_get_iframe_window().layer.closeAll();
                        callback(1,"信息显示切换成功");
                        return;
                    });
                },ui_screen_delay);
                return;
            });
            return;
        },obj_param.b_create,obj_param.ui_add_cnt);
    }
    return;
}

/*
 * 组合、编辑、拆分
 * 1. 存在至少两张卡
 * 2. 全选
 * 3. 连线（HUB卡下）
 * 4. 组合
 * 5. 编辑
 * 6. 拆分
 */
function tc_module_operate_compose(callback) {
    tc_tool_judge_jump_page(str_screen_url,str_screen_url_param,operate_compose);
    function operate_compose() {
        var iframe_document = get_webui_main_document();
        var obj_window = tc_tool_get_iframe_window();
        var obj_param = tool_screen_judge_is_create(iframe_document,2);

        // 1.
        tool_screen_add_box(callback,function () {
            // 2.
            iframe_document.onkeydown({keyCode: 65,ctrlKey: true});
            // 3.
            tool_screen_connect_line(obj_window,iframe_document,callback,function () {
                // 4.
                iframe_document.querySelector("div[lang_id='MC_LANG_COMPOSE']").click();
                // 5.
                obj_window.mc_compose_edit();
                setTimeout(function () {
                    var arr_create_select = [$(iframe_document.getElementsByClassName("mc_mod")[0])];
                    var str_redo_undo = "";
                    var ui_module_cnt = 0;

                    obj_window.arr_select_mod = arr_create_select;
                    obj_window.arr_mod_selected = arr_create_select;
                    setTimeout(function () {
                        obj_window.mc_compose_edit();
                        // 6.
                        obj_window.mc_compose_split_apply();
                        // redo undo
                        ui_module_cnt = iframe_document.getElementsByClassName("mc_mod").length;
                        tool_screen_redo_undo(iframe_document,true).then(()=>{
                            if (--ui_module_cnt === iframe_document.getElementsByClassName("mc_mod").length) {
                                str_redo_undo += "merge 回撤成功,";
                            } else {
                                str_redo_undo += "merge 回撤失败,";
                            }
                            return tool_screen_redo_undo(iframe_document,false);
                        }).then(()=>{
                            if (ui_module_cnt + 1 === iframe_document.getElementsByClassName("mc_mod").length) {
                                str_redo_undo += "merge 重做成功";
                            } else {
                                str_redo_undo += "merge 重做失败";
                            }
                            callback(1,"组合编辑拆分测试成功;" + str_redo_undo);
                        });
                        return;
                    },ui_screen_delay);
                    return;
                },ui_screen_delay);
                return;
            },true);
            return;
        },obj_param.b_create,obj_param.ui_add_cnt);
    }
    return;
}

/*
 * 定位
 * 1. 存在至少两张卡
 * 2. 全选
 * 3. 设置平铺数值64、排列2X1、定位10X10、偏移10X10
 * 4. 上对齐 -> 水平平铺 -> 左对齐 -> 垂直平铺 -> 下对齐 -> 排列 -> 右对齐 -> 定位 -> 偏移
 */
function tc_module_operate_position(callback) {
    tc_tool_judge_jump_page(str_screen_url,str_screen_url_param,operate_position);
    function operate_position() {
        var iframe_document = get_webui_main_document();
        var obj_window = tc_tool_get_iframe_window();
        var obj_param = tool_screen_judge_is_create(iframe_document,2);

        // 1.
        tool_screen_add_box(callback,function () {
            // 2.
            iframe_document.onkeydown({keyCode: 65,ctrlKey: true});
            obj_window.mc_lang_positioning_module();
            setTimeout(function () {
                var obj_pop_layer = tc_tool_get_iframe_pop_layer(iframe_document);

                if (!obj_pop_layer) {
                    callback(0,str_screen_error);
                    return;
                }
                tc_tool_window_load_complete(obj_pop_layer,function () {
                    // 3.
                    var obj_inp_list = obj_pop_layer.getElementsByClassName("mc_edit_input");
                    var arr_val = [64,2,1,10,10,10,10];

                    for (var i = 0; i < obj_inp_list.length; i++) {
                        var edit_item = obj_inp_list[i];

                        edit_item.value = arr_val[i];
                        edit_item.onblur({type: "blur",target: edit_item});
                    }
                    // 4.
                    operate_click(tool_screen_search_langid_get_dom(obj_pop_layer,"MC_LANG_UP_ALIGN"))
                        .then(()=>{
                            return operate_click(tool_screen_search_langid_get_dom(obj_pop_layer,"MC_LANG_VERTICAL","span"));
                        }).then(()=>{
                            return operate_click(tool_screen_search_langid_get_dom(obj_pop_layer,"MC_LANG_LEFT_ALIGN"));
                        }).then(()=>{
                            return operate_click(tool_screen_search_langid_get_dom(obj_pop_layer,"MC_LANG_HORIZONTAL","span"));
                        }).then(()=>{
                            return operate_click(tool_screen_search_langid_get_dom(obj_pop_layer,"MC_LANG_BOTTOM_ALIGN"));
                        }).then(()=>{
                            // MC_LANG_BTN_APPLY
                            return operate_click(tool_screen_search_langid_get_dom(obj_pop_layer.getElementById("mc_arrange"),"MC_LANG_BTN_APPLY","span"));
                        }).then(()=>{
                            return operate_click(tool_screen_search_langid_get_dom(obj_pop_layer,"MC_LANG_RIGHT_ALIGN"));
                        }).then(()=>{
                            return operate_click(obj_pop_layer.getElementById("mc_position"));
                        }).then(()=>{
                            return operate_click(tool_screen_search_langid_get_dom(obj_pop_layer.getElementById("mc_deviation"),"MC_LANG_BTN_APPLY","span"));
                        }).then(()=>{
                            callback(1,"定位成功");
                        });
                    return;
                });
            },ui_screen_delay);
            return;
        },obj_param.b_create,obj_param.ui_add_cnt);
        return;
    }
    function operate_click(obj_dom) {
        return new Promise(function (resolve) {
            setTimeout(function () {
                if (obj_dom) {
                    obj_dom.click();
                }
                resolve();
            },ui_screen_delay);
        });
    }
    return;
}

/*
 * 锁定
 * 1. 存在至少一张卡
 * 2. 全选
 * 3. 锁定（测试是否被锁定）
 * 4. 解锁
 */
function tc_module_operate_lock(callback) {
    tc_tool_judge_jump_page(str_screen_url,str_screen_url_param,operate_lock);
    function operate_lock() {
        var iframe_document = get_webui_main_document();
        var obj_window = tc_tool_get_iframe_window();

        // 1.
        tool_screen_add_box(callback,function () {
            var ui_module_cnt = iframe_document.getElementsByClassName("mc_mod").length;
            var str_redo_undo = "";

            // 2.
            iframe_document.onkeydown({keyCode: 65,ctrlKey: true});
            // 3.
            obj_window.mc_lang_lock_mod();
            setTimeout(function () {
                if (iframe_document.getElementsByClassName("mc_lock_icon").length === ui_module_cnt) {
                    // 4.
                    obj_window.mc_lang_lock_mod();
                    // redo undo
                    tool_screen_redo_undo(iframe_document,true).then(()=>{
                        if (0 !== iframe_document.getElementsByClassName("mc_lock").length) {
                            str_redo_undo += "lock 回撤成功,";
                        } else {
                            str_redo_undo += "lock 回撤失败,";
                        }
                        return tool_screen_redo_undo(iframe_document,false);
                    }).then(()=>{
                        if (0 === iframe_document.getElementsByClassName("mc_lock").length) {
                            str_redo_undo += "lock 重做成功";
                        } else {
                            str_redo_undo += "lock 重做失败";
                        }
                        callback(1,"锁定成功;" + str_redo_undo);
                    });
                    return;
                }
                callback(0,"锁定失败");
                return;
            },ui_screen_delay);
            return;
        });
        return;
    }
    return;
}

/*
 * 变换
 * 1. 存在至少两张卡
 * 2. 全选
 * 3. 变换设置 缩放0.9、旋转45、左右镜像、宽高32，应用
 * 4. 拼接变换 上下镜像、打开拼接，应用
 */
function tc_module_operate_transform(callback) {
    tc_tool_judge_jump_page(str_screen_url,str_screen_url_param,operate_transform);
    function operate_transform() {
        var iframe_document = get_webui_main_document();
        var obj_window = tc_tool_get_iframe_window();
        var obj_param = tool_screen_judge_is_create(iframe_document,2);

        // 1.
        tool_screen_add_box(callback,function () {
            // 2.
            var obj_pop_layer = null;
            var str_redo_undo = "";

            iframe_document.onkeydown({keyCode: 65,ctrlKey: true});
            obj_window.mc_lang_transformation_module();
            tool_screen_promise(function () {
                obj_pop_layer = tc_tool_get_iframe_pop_layer(iframe_document);

                if (!obj_pop_layer) {
                    callback(0,str_screen_error);
                    return;
                }
                tc_tool_window_load_complete(obj_pop_layer,function () {
                    // 3.
                    var obj_inp_list = obj_pop_layer.getElementsByClassName("mc_edit_input");
                    var arr_val = [0.9,0.9,45,32,32];

                    for (var i = 0; i < obj_inp_list.length; i++) {
                        var edit_item = obj_inp_list[i];

                        edit_item.value = arr_val[i];
                        edit_item.onblur({type: "blur",target: edit_item});
                    }
                    tool_screen_search_langid_get_dom(obj_pop_layer,"MC_LANG_LEFT_RIGHT").onmousedown();
                    return;
                });
                return;
            }).then(()=>{
                return tool_screen_promise(function () {
                    tool_screen_search_langid_get_dom(obj_pop_layer,"MC_LANG_BTN_APPLY").click();
                });
            }).then(()=> {
                return tool_screen_promise(function () {
                    obj_window.mc_lang_transformation_module();
                });
            }).then(()=>{
                return tool_screen_promise(function () {
                    obj_pop_layer = tc_tool_get_iframe_pop_layer(iframe_document);

                    if (!obj_pop_layer) {
                        callback(0,str_screen_error);
                        return;
                    }
                    tool_screen_search_langid_get_dom(obj_pop_layer,"MC_LANG_UP_DOWN").onmousedown();
                    obj_pop_layer.getElementsByClassName("mc_checkbox_box")[0].click();
                });
            }).then(()=>{
                return tool_screen_promise(function () {
                    tool_screen_search_langid_get_dom(obj_pop_layer,"MC_LANG_BTN_APPLY").click();
                });
            }).then(()=>{
                // redo undo
                tool_screen_redo_undo(iframe_document,true).then(()=>{
                    if ("41,41,20,0_45_0.9,0.9_1" === iframe_document.getElementsByClassName("mc_mod")[0].getAttribute("transform_msg")) {
                        str_redo_undo += "transform 回撤成功,";
                    } else {
                        str_redo_undo += "transform 回撤失败,";
                    }
                    return tool_screen_redo_undo(iframe_document,false);
                }).then(()=>{
                    if ("32,32,0,0_0_1.0,1.0_2" === iframe_document.getElementsByClassName("mc_mod")[0].getAttribute("transform_msg")) {
                        str_redo_undo += "transform 重做成功";
                    } else {
                        str_redo_undo += "transform 重做失败";
                    }
                    callback(1,"变换成功;" + str_redo_undo);
                });
            });
            return;
        },obj_param.b_create,obj_param.ui_add_cnt);
        return;
    }
    return;
}

/*
 * 行选、列选、取消选中
 * 1. 清屏创建2X2卡
 * 2. 取消选中
 * 3. 行选
 * 4. 列选
 */
function tc_module_operate_select(callback) {
    tc_tool_judge_jump_page(str_screen_url,str_screen_url_param,operate_select);
    function operate_select() {
        var iframe_document = get_webui_main_document();
        var obj_window = tc_tool_get_iframe_window();

        // 1.
        tool_screen_add_box(callback,function () {
            // 2.
            obj_window.mc_lang_deselect_mod();
            tool_screen_promise(function () {
                // 3.
                obj_window.arr_select_mod = [$(iframe_document.getElementsByClassName("mc_mod")[0])];
                obj_window.mc_select_ranks("X");
            }).then(()=>{
                // 4.
                return tool_screen_promise(function () {
                    obj_window.mc_select_ranks("Y");
                });
            }).then(()=>{
                return callback(1,"行选、列选、取消选中，成功");
            });
            return;
        },true,2,2,true);
        return;
    }
    return;
}

function tc_module_operate_size(callback) {
    tc_tool_judge_jump_page(str_screen_url,str_screen_url_param,operate_size);
    function operate_size() {
        var iframe_document = get_webui_main_document();
        var obj_inp_list = iframe_document.getElementById("mc_canvas_msg").getElementsByClassName("mc_edit_input");

        tool_screen_update_inp(obj_inp_list,[4000,2000]);
        callback(1,"更改成功");
        return;
    }
    return;
}

/*
 * 模块替换
 * 1. 至少存在一个箱体
 * 2. 添加一个新建箱体（清空）
 * 3. 替换为当前第一个（非新建）箱体
 */
function tc_module_operate_replace(callback) {
    tc_tool_judge_jump_page(str_screen_url,str_screen_url_param,operate_replace);
    function operate_replace() {
        // 1.
        tool_screen_create_box(function (b_operate) {
            if (!b_operate) {
                callback(0,str_screen_operate_error);
                return;
            }
            tool_screen_add_box(callback,set_add);
            return;
        });
    }

    function set_add() {
        // 2.
        tool_screen_add_box(callback,function () {
            // 3.
            var iframe_document = get_webui_main_document();
            var obj_dom = tool_screen_search_langid_get_dom(iframe_document,"MC_LANG_REPLACE");

            if (obj_dom) {
                obj_dom.click();
                callback(1,"替换成功");
            } else {
                callback(0,str_screen_operate_error);
            }
            return;
        },true,false,false,true,"-1");
        return;
    }
    return;
}

/*
 * 应用、添加大屏
 * 1. 至少存在一个箱体
 * 2. 存在连线队列
 * 3. 应用
 * 4. 添加大屏
 */
function tc_module_operate_add_screen(callback) {
    tc_tool_judge_jump_page(str_screen_url,str_screen_url_param,operate_add_screen);

    // 1.
    function operate_add_screen() {
        var iframe_document = get_webui_main_document();
        var obj_window = tc_tool_get_iframe_window();

        tool_screen_add_box(callback,function () {
            // 2.
            if (0 === Object.keys(obj_window.obj_same_hub_queue).length) {
                iframe_document.onkeydown({keyCode: 65,ctrlKey: true});
                tool_screen_connect_line(obj_window,iframe_document,callback,function () {
                    add_screen(iframe_document,obj_window);
                    return;
                });
                return;
            }
            add_screen(iframe_document,obj_window);
            return;
        },false,false,false,false,false);
    }

    function add_screen(iframe_document,obj_window) {
        // 3.
        iframe_document.getElementsByClassName("mc_btn_group_right")[0].querySelector("div[lang_id='MC_LANG_BTN_APPLY']").click();
        tc_tool_dialog_define_cancel(true);
        // 4.
        tool_screen_promise(function () {
            return tool_screen_search_langid_get_dom(iframe_document,"MC_LANG_ADD_SCREEN_INFO").click();
        }).then(()=>{
            return tool_screen_promise(function () {
                var obj_pop_layer = tc_tool_get_iframe_pop_layer(iframe_document);

                if (!obj_pop_layer) {
                    callback(0,str_screen_error);
                    return;
                }
                tc_tool_window_load_complete(obj_pop_layer,function () {
                    tool_screen_search_langid_get_dom(obj_pop_layer,"MC_LANG_BTN_APPLY").click();
                });
            });
        }).then(()=>{
            obj_window.layer.closeAll();
            callback(1,"应用、添加大屏成功");
        });
        return;
    }
    return;
}


// =================================Integration==================================
/*
* 箱体 发送/固化
* 1. 不存在箱体，进行创建（非新建）
* 2. 画布中不存在箱体，进行创建
* 3. 不存在连线数据，进行连线
* 4. 发送箱体数据 / 箱体偏移
* 5. 固化箱体数据 / 箱体偏移
*
* 保存文件
* 1-3. 同上
* 4. 保存文件
*/
function tc_box_send(str_btn_lang,callback) {
    tc_tool_judge_jump_page(str_screen_url,str_screen_url_param,send_and_load);

    // 1
    function send_and_load() {
        tool_screen_create_box(function (b_operate) {
            if (!b_operate) {
                callback(0,str_screen_operate_error);
                return;
            }
            tool_screen_add_box(callback,set_connect);
            return;
        });
    }

    function set_connect(obj_document) {
        var obj_window = tc_tool_get_iframe_window();

        // 3.
        if (0 === Object.keys(obj_window.obj_same_hub_queue).length) {
            tool_screen_connect_line(obj_window,obj_document,callback,function () {
                send_data(obj_document);
                return;
            });
            return;
        }
        send_data(obj_document);
        return;
    }

    function send_data(obj_document) {
        obj_document.querySelector("div[lang_id='" + str_btn_lang + "']").click();
        setTimeout(function () {
            if ("MC_LANG_BTN_SCREEN_SAVE_TO_FILE" === str_btn_lang) {
                callback(1,"保存文件成功");
                return;
            }
            var obj_pop_layer = get_webui_pop_leyer();

            if (!obj_pop_layer) {
                callback(0,str_screen_error);
                return;
            }
            var obj_main = tc_tool_get_main_htmliframe();

            obj_pop_layer = obj_pop_layer.children[1].children[0].contentDocument;
            tc_tool_window_load_complete(obj_pop_layer,function () {
                obj_pop_layer.getElementsByClassName("icon-hardware-write")[0].click();
                setTimeout(function () {
                    obj_main.contentWindow.layer.closeAll("dialog");
                    // 5.
                    obj_pop_layer.getElementsByClassName("icon-hardware-save")[0].click();
                    setTimeout(function () {
                        var str_tip = "";

                        if ("MC_LANG_BOX_CONFIGURATION_SEND_LOAD" === str_btn_lang) {
                            str_tip = "发送固化箱体成功";
                        } else {
                            str_tip = "发送固化箱体偏移成功";
                        }
                        callback(1,str_tip);
                        return;
                    },ui_screen_delay);
                },ui_screen_delay);
                return;
            });
        },ui_screen_delay);
        return;
    }
}

// ===================================TOOL=======================================
/*
* 当前不存在箱体（非新建）创建一个
* 1. 跳转模组向导页面
* 2. 应用模组
* 3. 跳转回大屏界面
*/
async function tool_screen_create_box(callback) {
    if (0 < tc_tool_get_main_htmliframe().contentWindow.ARY_BOX_DATA.length) {
        callback(true);
        return;
    }
    // 1.
    tc_tool_jump_page("./pages/mod_wizard/mod_wizard.html?is_save=false",false,function () {
        var iframe_document = get_webui_main_document();

        if (!iframe_document) {
            callback(false);
            return;
        }

        tc_tool_window_load_complete(iframe_document,function () {
            var apply_btn = iframe_document.getElementById("mc_btn_id_apply");

            if ("[object HTMLDivElement]" !== Object.prototype.toString.call(apply_btn)) {
                callback(false);
                return;
            }
            // 2.
            apply_btn.click();
            var obj_dialog = tc_tool_get_main_htmliframe().contentDocument.getElementsByClassName("layui-layer-dialog");

            tc_tool_dialog_define_cancel(true,obj_dialog);
            setTimeout(function () {
                tc_tool_window_load_complete(get_webui_main_document(),function () {
                    // 3
                    tc_tool_jump_page("./pages/box_design/height_lever_layout.html?enter=add_screen&is_save=false",false,function () {
                        callback(true);
                    });
                });
            },ui_screen_delay);
            return;
        });
    });
    return;
}

/*
* 当前画布中不存在箱体 创建
* [1]. callback
* [2]. Function 回调
* [3]. 直接添加（无论是否存在箱体）
* [4]. 添加行数
* [5]. 添加列数
* [6]. 是否清屏
* [7]. 添加项index
*/
function tool_screen_add_box(callback,fn_contusion,b_add,ui_row,ui_col,b_clear,str_index) {
    var iframe_document = get_webui_main_document();

    tc_tool_window_load_complete(iframe_document,function () {
        if (0 === iframe_document.getElementsByClassName("mc_mod").length || b_add) {
            iframe_document.querySelector("div[lang_id='MC_LANG_ADD']").click();
            setTimeout(function () {
                var obj_pop_layer = tc_tool_get_iframe_pop_layer(iframe_document);

                if (!obj_pop_layer) {
                    callback(0,str_screen_error);
                    return;
                }
                tc_tool_window_load_complete(obj_pop_layer,function () {
                    var obj_add_lise = obj_pop_layer.getElementsByClassName("mc_btn_group_left")[0].getElementsByClassName("mc_step_add");

                    row_col_val(obj_add_lise[0],ui_row);
                    row_col_val(obj_add_lise[1],ui_col);
                    if (b_clear) {
                        obj_pop_layer.getElementsByClassName("mc_checkbox_box")[0].click();
                    }
                    if ("[object String]" === Object.prototype.toString.call(str_index)) {
                        obj_pop_layer.querySelector("div[index='" + str_index + "']").click();
                    }
                    obj_pop_layer.getElementsByClassName("icon-btn-apply")[0].click();

                    fn_contusion(iframe_document);
                });
            },ui_screen_delay);
            return;
        }
        fn_contusion(iframe_document);
        return;
    });
    return;

    function row_col_val(obj_btn,ui_cnt) {
        if ("[object HTMLDivElement]" !== Object.prototype.toString.call(obj_btn)) {
            return false;
        }
        if ("[object Number]" !== Object.prototype.toString.call(ui_cnt)) {
            return false;
        }
        ui_cnt -= 1;
        for (var index = 0; index < ui_cnt; index++) {
            obj_btn.click();
        }
        return true;
    }
}

/*
* 连线
* [1]. 顶层 window
* [2]. 当前 document 对象
* [3]. callback
* [4]. Function 回调
* [5]. b_open_hubport 开启HUB卡口
*/
function tool_screen_connect_line(obj_window,obj_document,callback,fn_contusion,b_open_hubport) {
    obj_document.getElementsByClassName("mc_mod")[0].click();
    obj_window.mc_lang_ligature_module();
    setTimeout(function () {
        var obj_pop_layer = tc_tool_get_iframe_pop_layer(obj_document);

        if (!obj_pop_layer) {
            callback(0,str_screen_error);
            return;
        }
        tc_tool_window_load_complete(obj_pop_layer,function () {
            if (b_open_hubport) {
                var obj_checkbox = obj_pop_layer.getElementById("mc_setcard").getElementsByClassName("mc_checkbox_box")[0];

                if ("false" === obj_checkbox.getAttribute("checkbox_select")) {
                    obj_checkbox.click();
                }
            }
            obj_pop_layer.getElementById("horz_even").click();
            obj_window.layer.closeAll();
            fn_contusion();
            return;
        });
    },1000);
    return;
}

/*
* 获取指定lang_id 的元素
* [1]. 当前 document 对象
* [2]. lang_id
*/
function tool_screen_search_langid_get_dom(obj_document,str_lang,label_type) {
    label_type = label_type || "div";
    return obj_document.querySelector("" + label_type + "[lang_id='" + str_lang + "']");
}

// Promise
function tool_screen_promise(fn_callback) {
    return new Promise(function (resolve) {
        setTimeout(function () {
            if ("[object Function]" === Object.prototype.toString.call(fn_callback)) {
                fn_callback();
            }
            resolve();
        },ui_screen_delay);
    });
}

// 更改Input 触发回调
function tool_screen_update_inp(obj_inp_list,arr_val) {
    if ("[object HTMLCollection]" !== Object.prototype.toString.call(obj_inp_list)) {
        return false;
    }
    if ("[object Array]" !== Object.prototype.toString.call(arr_val)) {
        return false;
    }
    for (var i = 0; i < obj_inp_list.length; i++) {
        var edit_item = obj_inp_list[i];

        edit_item.value = arr_val[i];
        edit_item.onblur({type: "blur",target: edit_item});
    }
    return true;
}

/*
* 触发回撤重做按钮
* [1]. 当前 document 对象
* [2]. 是否回撤
*/
function tool_screen_redo_undo(obj_document,b_redo) {
    return tool_screen_promise(function () {
        var str_lang = "MC_LANG_REDO";

        if (b_redo) {
            str_lang = "MC_LANG_RETREAT";
        }
        tool_screen_search_langid_get_dom(obj_document,str_lang).click();
    });
}

/*
* 获取添加卡参数
* [1]. 当前 document 对象
* [2]. 至少存在几张
*/
function tool_screen_judge_is_create(obj_document,ui_cnt) {
    var ui_add_cnt = obj_document.getElementsByClassName("mc_mod").length;
    var b_create = true;

    ui_add_cnt = ui_cnt <= ui_add_cnt ? 0 : ui_cnt - ui_add_cnt;
    if (!ui_add_cnt) {
        b_create = false;
    }
    return {
        // 添加卡数量
        ui_add_cnt: ui_add_cnt,
        // 是否添加
        b_create: b_create
    };
}
